#ifdef SKINNING

uniform mat4 	boneMatrices[100];
attribute vec4  weights;
attribute vec4  matrixIndices;

#endif

varying vec4	pos;

void main()
{

#ifdef SKINNING

 	vec4 position = vec4( 0.0, 0.0, 0.0, 0.0 );
 	position = position + ((boneMatrices[int(matrixIndices.x)] * gl_Vertex) * weights.x);
	position = position + ((boneMatrices[int(matrixIndices.y)] * gl_Vertex) * weights.y);
	position = position + ((boneMatrices[int(matrixIndices.z)] * gl_Vertex) * weights.z);
	position = position + ((boneMatrices[int(matrixIndices.w)] * gl_Vertex) * weights.w);
	gl_Position = gl_ModelViewProjectionMatrix * position;
	pos=(gl_ModelViewMatrix * position);

#else

	gl_Position = ftransform();
	pos=(gl_ModelViewMatrix * gl_Vertex);

#endif
	
}